(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5790,        176]*)
(*NotebookOutlinePosition[      6553,        202]*)
(*  CellTagsIndexPosition[      6509,        198]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Simplify[
      InverseFourierTransform[1/\((k - \ 4  \[Pi]\^2\ m\ s\^2)\), s, t, 
        FourierParameters \[Rule] {0, \(-2\) \[Pi]}, 
        Assumptions -> k > 0\  && \ m > 0], k > 0 && m > 0]\)], "Input"],

Cell[BoxData[
    \(Simplify[
      FourierTransform[\ 
        I\ Exp[\(-I\)\ \(\@\(k/m\)\) Abs[t]]/\((2 \@\( k*m\))\), t, s, 
        FourierParameters \[Rule] {0, \(-2\) \[Pi]}], 
      m > 0\  && \ k > 0]\)], "Input"],

Cell[BoxData[
    \(w[t_] = 
      Integrate[\(1\/\[Epsilon]\) 
          I\ Exp[\(-I\)\ \(\@\(k/m\)\) Abs[t - u]]/\((2 \@\( k*m\))\), {u, 
          0, \[Epsilon]}, 
        Assumptions \[Rule] 
          k > 0\  && \ m > 0\  && \ 0 < t < \[Epsilon]]\)], "Input"],

Cell[BoxData[
    \(r[t_] = 
      FullSimplify[Re[w[t]], \[Epsilon] > t > 0 && k > 0 && m > 0]\)], "Input"],

Cell[BoxData[
    \(FullSimplify[
      m*\(r''\)[t] + k*r[t], \[Epsilon] > t > 0 && k > 0 && m > 0]\)], "Input"],

Cell[BoxData[
    \(r[t] /. {\@\(k\/m\) \[Rule] \[Omega], 
        k \[Rule] \[Omega]\^2\ m}\)], "Input"],

Cell[BoxData[
    \(u[t_] = 
      Integrate[\(1\/\[Epsilon]\) 
          I\ Exp[\(-I\)\ \(\@\(k/m\)\) Abs[t - u]]/\((2 \@\( k*m\))\), {u, 
          0, \[Epsilon]}, 
        Assumptions \[Rule] 
          k > 0\  && \ m > 0\  && \ 0 < \[Epsilon] < t]\)], "Input"],

Cell[BoxData[
    \(s[t_] = 
      FullSimplify[Re[Expand[ExpToTrig[u[t]]]], 
        t > \[Epsilon] > 0 && k > 0 && m > 0]\)], "Input"],

Cell[BoxData[
    \(s[t] /. {\@\(k\/m\) \[Rule] \[Omega], 
        k \[Rule] \[Omega]\^2\ m}\)], "Input"],

Cell[BoxData[
    \(FullSimplify[m*\(s''\)[t] + k*s[t], 
      t > \[Epsilon] > 0 && k > 0 && m > 0]\)], "Input"],

Cell[BoxData[
    \(d[t_] = Simplify[r[t] + s[t]]\)], "Input"],

Cell[BoxData[
    \(d[t] /. {\@\(k\/m\) \[Rule] \[Omega], 
        k \[Rule] \[Omega]\^2\ m}\)], "Input"],

Cell[BoxData[{
    \(Limit[
      Limit[r[t], t \[Rule] 0, Direction \[Rule] \(-1\)], \[Epsilon] \[Rule] 
        0, Direction \[Rule] \(-1\)]\), "\[IndentingNewLine]", 
    \(Limit[
      Limit[s[t], t \[Rule] 0, Direction \[Rule] \(-1\)], \[Epsilon] \[Rule] 
        0, Direction \[Rule] \(-1\)]\)}], "Input"],

Cell[BoxData[{
    \(Limit[r[t], t \[Rule] \[Epsilon], 
      Direction \[Rule] 1]\), "\[IndentingNewLine]", 
    \(Limit[s[t], t \[Rule] \[Epsilon], Direction \[Rule] \(-1\)]\)}], "Input"],

Cell[BoxData[
    \(FullSimplify[m*\(d''\)[t] + k*d[t], k > 0 && m > 0]\)], "Input"],

Cell[BoxData[
    \(Limit[\(-\(\(p\ \((\(-2\) + Cos[\@\(k\/m\)\ t] + 
                  Cos[\@\(k\/m\)\ \((t - \[Epsilon])\)])\)\)\/\(\(\ \)\(k\ \
\[Epsilon]\)\)\)\), t \[Rule] \[Epsilon], 
      Direction \[Rule] \(-1\)]\)], "Input"],

Cell[BoxData[
    \(Limit[\(p\ \((\(-Cos[\@\(k\/m\)\ t]\) + Cos[\@\(k\/m\)\ \((t - \
\[Epsilon])\)])\)\)\/\(\(\ \)\(k\ \[Epsilon]\)\), t \[Rule] \[Epsilon], 
      Direction \[Rule] 1]\)], "Input"],

Cell[BoxData[
    \(Limit[\(p - p\ Cos[\@\(k\/m\)\ t]\)\/\(k\ \[Epsilon]\), 
      t \[Rule] \[Epsilon], Direction \[Rule] \(-1\)]\)], "Input"],

Cell[BoxData[
    \(Table[
      Plot[\((1/\@\(2  \[Pi]\ t\))\) Exp[\(-x\^2\)/\((2\ t)\)], {x, \(-2.2\), 
          2.2}, PlotRange \[Rule] {0, 4.6}, AspectRatio \[Rule] 1, 
        PlotPoints \[Rule] 100], {t, 0.01, 0.2, 0.05}]\)], "Input"],

Cell[BoxData[
    \(Show[{Out[24], Out[25]}]\)], "Input"],

Cell[BoxData[
    \(Display["\<green.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Table[
      Plot[\((1/\@\(2  \[Pi]\ t\))\) Exp[\(-x\^2\)/\((2\ t)\)], {x, \(-2.2\), 
          2.2}, PlotRange \[Rule] {0, 4.6}, AspectRatio \[Rule] 1], {t, 0.4, 
        1, 0.25}]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`Arrow`\)], "Input"],

Cell[BoxData[
    \(Show[
      Graphics[{Arrow[{0, 0}, {0, 1}], Line[{{\(-1\), 0}, {1, 0}}], 
          Line[{{0, 0}, {0, 1.1}}], Thickness[ .007], Line[{{0, 0}, {0, 1}}], 
          Text[0, {0, \(- .05\)}]}]]\)], "Input"],

Cell[BoxData[
    \(Display["\<delta.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Options[Line]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 681}},
WindowSize->{1016, 643},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 229, 4, 82, "Input"],
Cell[1986, 57, 221, 5, 89, "Input"],
Cell[2210, 64, 264, 6, 99, "Input"],
Cell[2477, 72, 108, 2, 60, "Input"],
Cell[2588, 76, 113, 2, 60, "Input"],
Cell[2704, 80, 105, 2, 88, "Input"],
Cell[2812, 84, 264, 6, 99, "Input"],
Cell[3079, 92, 136, 3, 60, "Input"],
Cell[3218, 97, 105, 2, 88, "Input"],
Cell[3326, 101, 113, 2, 60, "Input"],
Cell[3442, 105, 62, 1, 60, "Input"],
Cell[3507, 108, 105, 2, 88, "Input"],
Cell[3615, 112, 311, 6, 81, "Input"],
Cell[3929, 120, 189, 3, 81, "Input"],
Cell[4121, 125, 84, 1, 60, "Input"],
Cell[4208, 128, 234, 4, 89, "Input"],
Cell[4445, 134, 197, 3, 89, "Input"],
Cell[4645, 139, 143, 2, 88, "Input"],
Cell[4791, 143, 241, 4, 88, "Input"],
Cell[5035, 149, 57, 1, 60, "Input"],
Cell[5095, 152, 71, 1, 60, "Input"],
Cell[5169, 155, 214, 4, 88, "Input"],
Cell[5386, 161, 51, 1, 60, "Input"],
Cell[5440, 164, 223, 4, 81, "Input"],
Cell[5666, 170, 71, 1, 60, "Input"],
Cell[5740, 173, 46, 1, 60, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

